/*
 * Decompiled with CFR 0.152.
 */
package org2.eclipse.php.internal.core.ast.scanner;

import com.aptana.core.resources.IUniformResource;
import java.text.MessageFormat;
import java.util.List;
import java_cup.runtime.Scanner;
import java_cup.runtime.Symbol;
import java_cup.runtime.lr_parser;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.Platform;
import org2.eclipse.dltk.compiler.problem.DefaultProblem;
import org2.eclipse.dltk.compiler.problem.IProblemReporter;
import org2.eclipse.php.internal.core.ast.nodes.AST;
import org2.eclipse.php.internal.core.ast.nodes.ASTError;
import org2.eclipse.php.internal.core.ast.scanner.AstLexer;

public abstract class AbstractASTParser
extends lr_parser {
    protected IProblemReporter problemReporter;
    protected Scanner scanner;
    public AST ast;

    public AbstractASTParser(Scanner scanner) {
        this.scanner = scanner;
    }

    public AbstractASTParser() {
    }

    public final void setAST(AST ast) {
        this.ast = ast;
    }

    public void setProblemReporter(IProblemReporter problemReporter) {
        this.problemReporter = problemReporter;
    }

    public IProblemReporter getProblemReporter() {
        return this.problemReporter;
    }

    protected List<ASTError> getErrors() {
        return this.ast.getErrors();
    }

    public final void report_error(String message, Object info) {
        if (!Platform.getPreferencesService().getBoolean("com.aptana.editor.common", MessageFormat.format("{0}:{1}", "com.aptana.contenttype.phtml.php", "com.aptana.editor.common.enableParseError"), true, null)) {
            return;
        }
        if (info instanceof Symbol) {
            Symbol s = (Symbol)info;
            if (s.left >= 0 && s.right >= s.left) {
                this.reportError(new ASTError(s.left, s.right, this.ast), message);
            }
        }
    }

    public final void report_fatal_error(String message, Object info) throws Exception {
        this.done_parsing();
    }

    protected void reportError(IProblemReporter problemReporter, Object resource, int start, int end, int lineNumber, String message) {
        String location = null;
        if (resource instanceof IResource) {
            location = ((IResource)resource).getLocation().toString();
        } else if (resource instanceof IUniformResource) {
            location = ((IUniformResource)resource).getURI().toString();
        }
        DefaultProblem problem = new DefaultProblem(location, message, 0x40000000, new String[0], 1, start, end, lineNumber);
        problemReporter.reportProblem(problem);
    }

    public void reportError(ASTError error, String message) {
        this.getErrors().add(error);
        if (message != null && this.problemReporter != null && this.ast.getResource() != null) {
            int lineNumber = ((AstLexer)this.getScanner()).getCurrentLine();
            this.reportError(this.problemReporter, this.ast.getResource(), error.getStart(), error.getEnd(), lineNumber, message);
        }
    }
}

